/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.6
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
// vB_CMS_Layout_Config
// #############################################################################

var layout_reserved_names = new Array("xyz_modified", "xyz_widgetid", "xyz_widgetinstanceid", "xyz_column");

/**
* Inits the layout configuration for drag & drop of widget placeholders
*
* @package	vBulletin
* @version	$Revision: 24798 $
* @date		$Date: 2007-11-22 13:59:49 +0000 (Thu, 22 Nov 2007) $
* @author	Freddie Bingham, vBulletin Development Team
*
* @param	string	HTML ID of html object containing the layout grid
* @param	string	Unique identifier for drag and drop objects, limiting interaction between items that share this id
* @param	array		Widgets to be added to the layout, in addition to any widgets that already exist in the layout grid
*/
function vB_CMS_Layout_Config(containerid, sGroup, widgetarray)
{
	if (AJAX_Compatible && (typeof vb_disable_ajax == 'undefined' || vb_disable_ajax < 2))
	{
		this.init(containerid, sGroup, widgetarray);
	}
}

/**
* Inititalization of Layout
*
* @param	string	HTML ID of html object containing the layout grid
* @param	string	Unique identifier for drag and drop objects, limiting interaction between items that share this id
* @param	array		Widgets to be added to the layout, in addition to any widgets that already exist in the layout grid
*/
vB_CMS_Layout_Config.prototype.init = function(containerid, sGroup, widgetarray)
{
	this.ddtargets = Array();
	this.sGroup = sGroup;
	this.widgetbox = YAHOO.util.Dom.get("widgetbox");
	this.form = YAHOO.util.Dom.get("cpform");
	this.activebox = null;
	this.backupbox = null;
	this.containerid = containerid;
	this.container = YAHOO.util.Dom.get(containerid);
	this.parambox = YAHOO.util.Dom.get("parambox");
	this.parambox_content = YAHOO.util.Dom.get("parambox_content");
	this.titlebox = YAHOO.util.Dom.get("ctrl_title").getElementsByTagName("input")[0];
	this.gridselect = YAHOO.util.Dom.get("ctrl_gridid").getElementsByTagName("select")[0];
	if (typeof this.inited == "undefined")
	{
		this.inited = false;
		this.idlist = Array();
		this.ddobjs = Array();
		this.ajaxreq = null;
		YAHOO.util.Event.on("paramsave", "click", this.saveparam, this, true);
		YAHOO.util.Event.on("paramcancel", "click", this.cancelparam, this, true);
		YAHOO.util.Event.on(this.form, "submit", this.save, this, true);
		YAHOO.util.Event.on("addwidget", "click", this.addwidget_event, this, true);
		YAHOO.util.Event.on(this.gridselect, "change",  this.fetchgrid, this, true);

		YAHOO.util.Dom.setStyle(this.parambox, "display", "");
		this.overlay = new vB_Overlay(this.parambox);
	}

	var wcontainers = this.container.getElementsByTagName("ul");
	var counter = 0;
	for (var i = 0; i < wcontainers.length; i++)
	{
		if (wcontainers[i].id.substr(0, 11) == "widgetlist_")
		{
			this.ddtargets[this.ddtargets.length] = new YAHOO.util.DDTarget(wcontainers[i], sGroup);
			var items = wcontainers[i].getElementsByTagName("li");
			if (items.length == 0)
			{
				YAHOO.util.Dom.setStyle(wcontainers[i], "paddingBottom", "60px");
			}
		}
	}

	if (widgetarray)
	{
		for (var x = 0; x < widgetarray.length; x++)
		{
			this.addwidget(widgetarray[x][0], widgetarray[x][1], widgetarray[x][2], widgetarray[x][3]);
		}
	}
	else
	{
		if (!this.inited)
		{
			// Add primary content block
			this.addwidget("content");
		}
	}

	this.inited = true;
}

/**
* Saves widget parameters
*
* @param	event
*/
vB_CMS_Layout_Config.prototype.saveparam = function(e)
{
	YAHOO.util.Event.stopEvent(e);
	this.hide_parambox(1);
}

/**
* Cancels widget editing
*
* @param	event
*/
vB_CMS_Layout_Config.prototype.cancelparam = function(e)
{
	YAHOO.util.Event.stopEvent(e);
	this.hide_parambox();
}

/**
* Event, fired by the > button, adds new widget to layout
*
* @param	event
*/
vB_CMS_Layout_Config.prototype.addwidget_event = function(e)
{
	YAHOO.util.Event.stopEvent(e);

	if (this.widgetbox.selectedIndex >= 0)
	{
		this.addwidget(1, this.widgetbox.options[this.widgetbox.selectedIndex].value, this.widgetbox.options[this.widgetbox.selectedIndex].text, 0);
	}
}

/**
* Handles AJAX request response
*
* @param	int			Layout column to place widget in
* @param	int			Unique id of widget
* @param	string	Widget title
* @param	int			Unique id of widget, from database, existing widgets only
*/
vB_CMS_Layout_Config.prototype.addwidget = function(column, widgetid, title, widgetinstanceid)
{
	var newli = document.createElement("li");
	var id = this.fetch_freeid();

	newli.setAttribute("id", "widget" + id);
	newli.widgetid = widgetid;
	newli.widgetinstanceid = widgetinstanceid;
	YAHOO.util.Dom.addClass(newli, "widget_container");

	var newdiv = document.createElement("div");
	newdiv.setAttribute("id", "widget" + id + "_div");
	newli.appendChild(newdiv);

	var newhandlediv = document.createElement("div");
	newhandlediv.setAttribute("id", "widget" + id + "_handle");
	YAHOO.util.Dom.addClass(newhandlediv, "widget_title");
	newdiv.appendChild(newhandlediv);

	var newdescdiv = document.createElement("div");
	newdescdiv.setAttribute("id", "widget" + id + "_desc");
	YAHOO.util.Dom.addClass(newdescdiv, "widget_description");
	if (!widgetid)
	{
		YAHOO.util.Dom.addClass(newhandlediv, "widget_title_primary");
		YAHOO.util.Dom.addClass(newdescdiv, "widget_description_primary");
	}
	else if (widgetinstanceid)
	{
		YAHOO.util.Dom.addClass(newhandlediv, "widget_title_active");
		YAHOO.util.Dom.addClass(newdescdiv, "widget_description_active");
	}
	newdiv.appendChild(newdescdiv);

	var newhandlediv2 = document.createElement("div");
	if (widgetid)
	{
		var newbutton = document.createElement("div");
		newbutton.setAttribute("id", "widget" + id + "_button");
		newbutton.innerHTML = 'x';
		newhandlediv.appendChild(newbutton);
		YAHOO.util.Dom.addClass(newbutton, "closebutton");
//		var newhref = document.createElement("a");
//		newhref.setAttribute("id", "widget" + id + "_param");
//		newhref.setAttribute("href", "#");
//		newhref.innerHTML = widgetinstanceid ? vbphrase["modify_params"] : vbphrase["define_params"];
//		newdescdiv.appendChild(newhref);
	}
	newhandlediv2.innerHTML = title;
	newhandlediv.appendChild(newhandlediv2);
	newhandlediv2.setAttribute("title", title);
	YAHOO.util.Dom.addClass(newhandlediv2, "title");

	var havecolumn = YAHOO.util.Dom.get("widgetlist_column" + column)
	if (havecolumn)
	{
		havecolumn.appendChild(newli);
	}
	else
	{
		YAHOO.util.Dom.get("widgetlist_column1").appendChild(newli);
	}

	// Init drag & drop
	this.ddobjs[id] = new vB_CMS_Layout_Widget(newli.id, this.sGroup, this);

}

/**
* Fetches an unique ID for a new widget
*
* @return	int	Widgetid
*/
vB_CMS_Layout_Config.prototype.fetch_freeid = function ()
{
	for (var i = 0; i < this.ddobjs.length; i++)
	{
		if (typeof(this.ddobjs[i]) == "undefined")
		{
			return i;
		}
	}

	return this.ddobjs.length;
}

/**
* Saves the layout
*
* @param	event
*/
vB_CMS_Layout_Config.prototype.save = function(e)
{
	YAHOO.util.Event.stopEvent(e);

	if (this.titlebox.value == "")
	{
		this.titlebox.focus();
		alert(vbphrase["please_enter_layout_title"]);
		return;
	}

	var save = false;
	var firstchild = this.form.firstChild;
	var wcontainers = this.container.getElementsByTagName("ul");
	for (var i = 0; i < wcontainers.length; i++)
	{
		if (wcontainers[i].id.substr(0, 11) == "widgetlist_")
		{
			var lis = wcontainers[i].getElementsByTagName("li");
			for (var x = 0; x < lis.length; x++)
			{

				var match = lis[x].id.match(/^widget(\d+)$/);
				var newfield = document.createElement("input");
				newfield.setAttribute("type", "hidden");
				newfield.setAttribute("name", "widgets[" + match[1] + "][xyz_widgetid]");
				newfield.setAttribute("value", lis[x].widgetid);
				this.form.insertBefore(newfield, firstchild);

				newfield = document.createElement("input");
				newfield.setAttribute("type", "hidden");
				newfield.setAttribute("name", "widgets[" + match[1] + "][xyz_column]");
				newfield.setAttribute("value", wcontainers[i].id);
				this.form.insertBefore(newfield, firstchild);

				}
			}
		}

		this.form.submit();
	}

/**
* Closes overlay, saves widget or cancel edit
*
* @param	int	Save / cancel
*/
vB_CMS_Layout_Config.prototype.hide_parambox = function(state)
{
	if (this.overlay.check_status(3))
	{
		this.overlay.set_status(0, "hide_parambox");
		this.overlay.hide()
		YAHOO.util.Dom.setStyle(this.activebox, "display", "none");

		var match = this.activebox.id.match(/^widget(\d+)_parambox$/);
		var id = match[1];

		if (typeof state != "undefined")
		{	// Save Form
			this.backupbox.parentNode.removeChild(this.backupbox);
			this.ddobjs[id].saved = 1;
			YAHOO.util.Dom.get("widget" + id + "_param").innerHTML = vbphrase["modify_params"];

			var widgettitle = YAHOO.util.Dom.get("widget" + id + "_handle");
			var widgetdesc = YAHOO.util.Dom.get("widget" + id + "_desc");
			YAHOO.util.Dom.addClass(widgettitle, "widget_title_active");
			YAHOO.util.Dom.addClass(widgetdesc, "widget_description_active");

			// Add a hidden input that this widget was modified (for existing widgets on layout edit)
			var newfield = document.createElement("input");
			newfield.setAttribute("type", "hidden");
			newfield.setAttribute("name", "widgets[" + id + "][xyz_modified]");
			newfield.setAttribute("id", "widget" + id + "_modified");
			newfield.setAttribute("value", 1);
			this.form.appendChild(newfield);
		}
		else
		{	// Cancel Form
			if (typeof this.ddobjs[id].saved == "undefined")
			{
				this.activebox.parentNode.removeChild(this.activebox);
				this.backupbox.parentNode.removeChild(this.backupbox);
			}
			else
			{
				// replace activebox with backupbox
				this.activebox.parentNode.replaceChild(this.backupbox, this.activebox);
			}
		}
		this.activebox = null;
	}
}

/**
* Fetches new grid via ajax
*
*/
vB_CMS_Layout_Config.prototype.fetchgrid = function()
{
	var gridid = this.gridselect[this.gridselect.selectedIndex].value;
	if (gridid > 0 && this.overlay.check_status(0) && !YAHOO.util.Connect.isCallInProgress(this.overlay.ajax_req))
	{
		this.overlay.set_status(2, "load grid html");
		this.overlay.showprogress();

		this.overlay.ajaxreq = YAHOO.util.Connect.asyncRequest("POST", "cms_admin.php", {
			success: this.displaygrid,
			failure: this.handle_ajax_error,
			timeout: vB_Default_Timeout,
			scope: this
		}, SESSIONURL + "securitytoken=" + SECURITYTOKEN + "&adminhash=" + ADMINHASH + "&ajax=1&do=gridhtml&gridid=" + gridid);
	}
}

/**
* Handles AJAX request response for grid swap
*
* @param	object	YUI AJAX
*/
vB_CMS_Layout_Config.prototype.displaygrid = function(ajax)
{
	this.overlay.hideprogress();
	if (!this.overlay.check_status(2))
	{
		return;
	}

	if (ajax.responseXML)
	{
		var error = ajax.responseXML.getElementsByTagName("error");
		if (error.length)
		{
			this.set_status(0, "display - error");
			alert(error[0].firstChild.nodeValue);
		}
		else
		{
			this.overlay.set_status(3, "handle_ajax_response - success");
			var html = string_to_node(ajax.responseXML.getElementsByTagName("html")[0].firstChild.nodeValue);
			YAHOO.util.Dom.setStyle(this.container, "display", "none");
			// move widgets to the new grid

			var containers = this.container.getElementsByTagName("ul");
			var newcontainers = html.getElementsByTagName("ul");

			var newcolumn1, newsidebar1, newheader1, newfooter1;
			for(var h = 0; h < newcontainers.length; h++)
			{
				if (!newheader1 && YAHOO.util.Dom.hasClass(newcontainers[h].parentNode, "yui-header"))
				{
					newheader1 = newcontainers[h];
				}
				if (!newsidebar1 && YAHOO.util.Dom.hasClass(newcontainers[h].parentNode, "yui-sidebar"))
				{
					newsidebar1 = newcontainers[h];
				}
				if (!newcolumn1 && YAHOO.util.Dom.hasClass(newcontainers[h].parentNode, "yui-panel"))
				{
					newcolumn1 = newcontainers[h];
				}
				if (!newfooter1 && YAHOO.util.Dom.hasClass(newcontainers[h].parentNode, "yui-footer"))
				{
					newfooter1 = newcontainers[h];
				}
			}

			var dest, length;
			for (var i = 0; i < containers.length; i++)
			{
				if (containers[i].id.substr(0, 11) == "widgetlist_")
				{
					dest = null;
					for(var h = 0; h < newcontainers.length; h++)
					{
						// Same column type and "location" so move straight over
						if (containers[i].id == newcontainers[h].id && containers[i].parentNode.className == newcontainers[h].parentNode.className)
						{
							dest = newcontainers[h];
						}
					}

					if (!dest)
					{
						if (YAHOO.util.Dom.hasClass(containers[i].parentNode, "yui-header") && newheader1)
						{
							dest = newheader1;
						}
						else if (YAHOO.util.Dom.hasClass(containers[i].parentNode, "yui-sidebar") && newsidebar1)
						{
							dest = newsidebar1;
						}
						else if (YAHOO.util.Dom.hasClass(containers[i].parentNode, "yui-panel") && newcolumn1)
						{
							dest = newcolumn1;
						}
						else if (YAHOO.util.Dom.hasClass(containers[i].parentNode, "yui-footer") && newfooter1)
						{
							dest = newfooter1;
						}
						else
						{
							dest = newcolumn1;
						}
					}

					var lis = containers[i].getElementsByTagName("li");
					var length = lis.length;
					for (var x = 0; x < length; x++)
					{
						dest.appendChild(lis[0]);
					}
				}
			}

			var newcontainer = this.container.parentNode.insertBefore(html, this.container);
			this.container.parentNode.removeChild(this.container);
			this.container = newcontainer;

			var length = this.ddtargets.length;
			for (var j = 0; j < length; j++)
			{
				this.ddtargets[j].unreg();
				delete this.ddtargets[j];
			}
			this.init(this.containerid, this.sGroup);
		}
	}
}

/**
* Handles AJAX Errors
*
* @param	object	YUI AJAX
*/
vB_CMS_Layout_Config.prototype.handle_ajax_error = function(ajax)
{
	this.overlay.hide();
	//TODO: Something bad happened, try again
	vBulletin_AJAX_Error_Handler(ajax);
}

/**
* Individual widget
*
* @param	string	Objectid
* @param	Unique identifier for drag and drop objects, limiting interaction between items that share this id
* @param	object Object that spawned thee
*/
function vB_CMS_Layout_Widget(objectid, sGroup, owner)
{
	this.init(objectid, sGroup, owner);
}

/**
* Initialize the widget
*
* @param	string	Objectid
* @param	Unique identifier for drag and drop objects, limiting interaction between items that share this id
* @param	object Object that spawned thee
*/
vB_CMS_Layout_Widget.prototype.init = function(objectid, sGroup, owner)
{
	var item = YAHOO.util.Dom.get(objectid);
	this.objectid = item.parentNode.id;

	if (item.id.substr(0, 6) == "widget")
	{
		var widgetid = YAHOO.util.Dom.get(item.id + "_widgetid");
		if (widgetid)
		{
			item.widgetid = widgetid.innerHTML;
		}
		var widgetinstanceid = YAHOO.util.Dom.get(item.id + "_widgetinstanceid");
		if (widgetinstanceid)
		{
			item.widgetinstanceid = widgetinstanceid.value;
		}

		var handle = YAHOO.util.Dom.get(item.id + "_handle");
		if (item.parentNode.id == this.objectid && handle)
		{
			owner.idlist[item.id.substr(6)] = item.id;
			var ddobj = new vB_CMS_Layout_Widget_DDProxy(item.id, sGroup);
			ddobj.addInvalidHandleId(item.id + "_button");
			ddobj.setHandleElId(item.id + "_handle");
			ddobj.owner = owner;
			YAHOO.util.Dom.setStyle(handle, "cursor", "move");

			YAHOO.util.Event.on(item.id + "_button", "click", ddobj.killwidget, ddobj, true);
			YAHOO.util.Event.on(item.id + "_param", "click", ddobj.editwidget, ddobj, true);
		}
	}

	YAHOO.util.Dom.setStyle(item.parentNode, "paddingBottom", "");
}

/**
* Extend YAHOO.util.DDProxy
*
* @param	string Objectid
* @param	Unique identifier for drag and drop objects, limiting interaction between items that share this id
*/
vB_CMS_Layout_Widget_DDProxy = function(id, sGroup, config)
{
	vB_CMS_Layout_Widget_DDProxy.superclass.constructor.call(this, id, sGroup, config);

	var el = this.getDragEl();
	YAHOO.util.Dom.setStyle(el, "opacity", 0.67);

	this.goingUp = false;
	this.lastY = 0;
}

YAHOO.extend(vB_CMS_Layout_Widget_DDProxy, YAHOO.util.DDProxy);

/**
* Extend YAHOO.util.DDProxy.startDrag
*
* @param	int	X Coordinate
* @param	int	Y Coordinate
*/
vB_CMS_Layout_Widget_DDProxy.prototype.startDrag = function(x, y)
{
	var dragEl = this.getDragEl();
	var clickEl = this.getEl();
	YAHOO.util.Dom.setStyle(clickEl, "visibility", "hidden");

	var listitems = clickEl.parentNode.getElementsByTagName("li");
	clickEl.parentNode.blockorder = "";
	for (var i = 0; i < listitems.length; i++)
	{
		var item = YAHOO.util.Dom.get(listitems[i]);
		var handle = YAHOO.util.Dom.get(item.id + "_handle");
		if (item.parentNode.id == clickEl.parentNode.id && handle)
		{
			clickEl.parentNode.blockorder += item.id;
		}
	}

	var licontent = YAHOO.util.Dom.get(clickEl.id + "_div");
	if (licontent)
	{
		var ghostobj = licontent.cloneNode(true);
		YAHOO.util.Dom.setStyle(ghostobj, "display", "none");
		clickEl.appendChild(ghostobj);
		YAHOO.util.Dom.setStyle(ghostobj, "margin", "0px");
		YAHOO.util.Dom.setStyle(ghostobj, "padding", "0px");
		YAHOO.util.Dom.setStyle(ghostobj, "borderWidth", "0px");
		dragEl.innerHTML = ghostobj.innerHTML;
		ghostobj.parentNode.removeChild(ghostobj);
	}
	else
	{
		dragEl.innerHTML = clickEl.innerHTML;
	}

	YAHOO.util.Dom.setStyle(dragEl, "color", YAHOO.util.Dom.setStyle(clickEl, "color"));
	YAHOO.util.Dom.setStyle(dragEl, "backgroundColor", YAHOO.util.Dom.setStyle(clickEl, "backgroundColor"));
	YAHOO.util.Dom.setStyle(dragEl, "border", "2px solid gray");

	YAHOO.util.Dom.setStyle(clickEl.parentNode, "borderWidth", "2px");
	YAHOO.util.Dom.setStyle(clickEl.parentNode, "borderColor", "red");
	YAHOO.util.Dom.setStyle(clickEl.parentNode, "borderStyle", "dashed");
	YAHOO.util.DragDropMgr.lastborderset = clickEl.parentNode.id;
}

/**
* Extend YAHOO.util.DDProxy.endDrag
*
* @param	event
*/
vB_CMS_Layout_Widget_DDProxy.prototype.endDrag = function (e)
{
	var srcEl = this.getEl();
	var dragEl = this.getDragEl();

	var blockorder = "";
	var submitstring = "";
	var listitems = srcEl.parentNode.getElementsByTagName("li");
	var count = 1;
	for (var i = 0; i < listitems.length; i++)
	{
		var item = YAHOO.util.Dom.get(listitems[i]);
		var handle = YAHOO.util.Dom.get(item.id + "_handle");
		if (item.parentNode.id == srcEl.parentNode.id && handle)
		{
			blockorder += item.id;
			submitstring += "&block[" + item.id + "]=" + count;
			count++;
		}
	}

	// Show the dragEl element and animate it to the src element's location
	YAHOO.util.Dom.setStyle(dragEl, "visibility", "");
	var a = new YAHOO.util.Motion
	(
		dragEl,
		{
			points:
			{
				to: YAHOO.util.Dom.getXY(srcEl)
			}
		},
		0.2,
		YAHOO.util.Easing.easeOut
	)
	var dragElid = dragEl.id;
	var thisid = this.id;
	var me = this;

	// Hide the dragEl and show the source element when finished with the animation
	a.onComplete.subscribe(
		function()
		{
			YAHOO.util.Dom.setStyle(dragElid, "visibility", "hidden");
			YAHOO.util.Dom.setStyle(thisid, "visibility", "");
			YAHOO.util.Dom.get(dragElid).innerHTML = "";
			me.clearborder(1);
		}
	);
	a.animate();
}

/**
* Extend YAHOO.util.DDProxy.onDrag
*
* @param	event
*/
vB_CMS_Layout_Widget_DDProxy.prototype.onDrag = function(e)
{
	// Keep track of the direction of the drag for use during onDragOver
	var y = YAHOO.util.Event.getPageY(e);

	if (y < this.lastY)
	{
		this.goingUp = true;
	}
	else if (y > this.lastY)
	{
		this.goingUp = false;
	}

	this.lastY = y;
}

/**
* Extend YAHOO.util.DDProxy.onDragOver
*
* @param	event
* @param	string	ID of object that we are over
*/
vB_CMS_Layout_Widget_DDProxy.prototype.onDragOver = function (e, id)
{
	var srcEl = this.getEl();
	var destEl = YAHOO.util.Dom.get(id);
	var dragEl = this.getDragEl();

	// We are only concerned with list items, we ignore the dragover
	// notifications for the list.
	if (destEl.nodeName.toLowerCase() == "li")
	{
		var orig_p = srcEl.parentNode;
		var p = destEl.parentNode;

		if (destEl.parentNode.id != srcEl.parentNode.id)
		{
			this.setborder(p);
		}

		if (this.goingUp)
		{
			p.insertBefore(srcEl, destEl); // insert above
		}
		else
		{
			p.insertBefore(srcEl, destEl.nextSibling); // insert below
		}
	}
	else if (destEl.nodeName.toLowerCase() == "ul" && destEl.id != srcEl.parentNode.id)
	{
		this.setborder(destEl);
		var listitems = destEl.getElementsByTagName("li");
		var dragElY = YAHOO.util.Dom.getY(dragEl);
		var append = true;
		for (var i = 0; i < listitems.length; i++)
		{
			listitemY = YAHOO.util.Dom.getY(listitems[i]);
			if (dragElY <= listitemY)
			{
				//alert(dragElY + " " + listitemY);
				destEl.insertBefore(srcEl, listitems[i]);
				append = false;
				break;
			}
		}
		if (append)
		{
			destEl.appendChild(srcEl);
		}
	}

	YAHOO.util.DragDropMgr.refreshCache();
}

/**
* Extend YAHOO.util.DDProxy.onDragDrop
*
* @param	event
* @param	string	ID of object that we dropped onto
*/
vB_CMS_Layout_Widget_DDProxy.prototype.onDragDrop = function (e, id)
{
	var destEl = YAHOO.util.Dom.get(id);
	// If there is one drop interaction, the li was dropped either on the list,
	// or it was dropped on the current location of the source element.
	if (YAHOO.util.DragDropMgr.interactionInfo.drop.length === 1)
	{
		// The position of the cursor at the time of the drop (YAHOO.util.Point)
		var pt = YAHOO.util.DragDropMgr.interactionInfo.point;

		// The region occupied by the source element at the time of the drop
		var region = YAHOO.util.DragDropMgr.interactionInfo.sourceRegion;

		// Check to see if we are over the source element's location.  We will
		// append to the bottom of the list once we are sure it was a drop in
		// the negative space (the area of the list without any list items)
		if (!region.intersect(pt))
		{
			var destEl = YAHOO.util.Dom.get(id);
			var destDD = YAHOO.util.DragDropMgr.getDDById(id);
		//	destEl.appendChild(this.getEl());
			destDD.isEmpty = false;
			YAHOO.util.DragDropMgr.refreshCache();
		}
	}
}

/**
*	Removes border from Drag & Drop area
*
* @param	bool	Final call to clearborder for this drag & drop?
*/
vB_CMS_Layout_Widget_DDProxy.prototype.clearborder = function(finalloc)
{
	if (typeof YAHOO.util.DragDropMgr.lastborderset != "undefined")
	{
		var list = YAHOO.util.Dom.get(YAHOO.util.DragDropMgr.lastborderset);
		YAHOO.util.Dom.setStyle(list, "borderWidth", "");
		YAHOO.util.Dom.setStyle(list, "borderColor", "");
		YAHOO.util.Dom.setStyle(list, "borderStyle", "");

		var items = list.getElementsByTagName("li");

		if (!finalloc && items.length == 1)
		{
			YAHOO.util.Dom.setStyle(list, "paddingBottom", "60px");
		}
	}
}

/**
* Add border to drag & drop area
*
* @param	object	Object to add border
*/
vB_CMS_Layout_Widget_DDProxy.prototype.setborder = function(obj)
{
	this.clearborder();
	YAHOO.util.Dom.setStyle(obj, "borderWidth", "2px");
	YAHOO.util.Dom.setStyle(obj, "borderColor", "red");
	YAHOO.util.Dom.setStyle(obj, "borderStyle", "dashed");
	YAHOO.util.Dom.setStyle(obj, "paddingBottom", "");
	YAHOO.util.DragDropMgr.lastborderset = obj.id;
}

/**
*	Remove widget from layout
*
* @param	event
*/
vB_CMS_Layout_Widget_DDProxy.prototype.killwidget = function(e)
{
	YAHOO.util.Event.stopEvent(e);

	var id = this.id.substr(6);
	var deleteobj = this.owner.ddobjs[id].saved ? confirm(vbphrase["remove_widget"]) : true;

	if (deleteobj)
	{
		var id = this.id.substr(6);
		delete this.owner.idlist[id];
		delete this.owner.ddobjs[id];

		var element = YAHOO.util.Dom.get(this.id);
		var parent = element.parentNode;
		var items = parent.getElementsByTagName("li");

		var parambox = YAHOO.util.Dom.get("widget" + id + "_parambox");
		if (parambox)
		{
			parambox.parentNode.removeChild(parambox);
		}

		parent.removeChild(element);
		if (items.length == 0)
		{
			YAHOO.util.Dom.setStyle(parent, "paddingBottom", "60px");
		}
	}
}

/**
* Edit widget - show overlay with widget parameters,
*
* @param	event
*/
vB_CMS_Layout_Widget_DDProxy.prototype.editwidget = function(e)
{
	if (this.owner.overlay.check_status(0) && !YAHOO.util.Connect.isCallInProgress(this.owner.overlay.ajax_req))
	{
		this.owner.overlay.show_background();
		this.owner.overlay.set_status(2, "load parambox");
		var box = YAHOO.util.Dom.get("widget" + this.id.substr(6) + "_parambox");
		if (box)
		{
			this.owner.overlay.set_status(3, "div exists - success");
			YAHOO.util.Dom.setStyle(box, "display", "");
			this.owner.activebox = box;
			this.owner.backupbox = this.cloneform(this.owner.activebox);
			YAHOO.util.Dom.setStyle(this.owner.backupbox, "display", "none");
			this.owner.parambox.appendChild(this.owner.backupbox);
			this.owner.overlay.show_overlaybox();
		}
		else
		{
			var element = YAHOO.util.Dom.get(this.id);
			this.owner.overlay.ajaxreq = YAHOO.util.Connect.asyncRequest("POST", "cms_admin.php", {
				success: this.display,
				failure: this.owner.handle_ajax_error,
				timeout: vB_Default_Timeout,
				scope: this
			}, SESSIONURL + "securitytoken=" + SECURITYTOKEN + "&adminhash=" + ADMINHASH + "&ajax=1&do=widgethtml&id=" + this.id.substr(6) + "&widgetid=" + element.widgetid + "&widgetinstanceid=" + element.widgetinstanceid);
		}
	}
}

/**
* Ajax response to display widget parameters
*
* @param	object	YUI AJAX
*/
vB_CMS_Layout_Widget_DDProxy.prototype.display = function(ajax)
{
	this.owner.overlay.hideprogress();
	if (!this.owner.overlay.check_status(2) || this.owner.activebox)
	{
		return;
	}

	if (ajax.responseXML)
	{
		var error = ajax.responseXML.getElementsByTagName("error");
		if (error.length)
		{
			this.owner.overlay.set_status(0, "display - error");
			alert(error[0].firstChild.nodeValue);
		}
		else
		{
			this.owner.overlay.set_status(3, "handle_ajax_response - success");

			var html = string_to_node(ajax.responseXML.getElementsByTagName("html")[0].firstChild.nodeValue);
			html.setAttribute("id", "widget" + this.id.substr(6) + "_parambox");
 			this.owner.activebox = this.owner.parambox_content.appendChild(html);
			// Rename inputs!
			var inputs = fetch_tags(this.owner.activebox, "input");
			var i, match;
			for (i = 0; i < inputs.length; i++)
			{
				if (match = inputs[i].name.match(/^(.+)(\[\])$/))
				{
					if (PHP.in_array(match[1], layout_reserved_names) > -1)
					{
						alert(vbphrase["do_not_use_the_following_input_field_names_in_widgets"]);
					}
					inputs[i].name = "widgets[" + this.id.substr(6) + "][" + match[1] + "][]";
				}
				else
				{
					if (PHP.in_array(inputs[i].name, layout_reserved_names) > -1)
					{
						alert(vbphrase["do_not_use_the_following_input_field_names_in_widgets"]);
					}
					inputs[i].name = "widgets[" + this.id.substr(6) + "][" + inputs[i].name + "]";
				}
			}

			// Rename textareas
			var textareas = fetch_tags(this.owner.activebox, "textarea");
			for (i = 0; i < textareas.length; i++)
			{
				if (match = textareas[i].name.match(/^(.+)(\[\])$/))
				{
					if (PHP.in_array(match[1], layout_reserved_names) > -1)
					{
						alert(vbphrase["do_not_use_the_following_input_field_names_in_widgets"]);
					}
					textareas[i].name = "widgets[" + this.id.substr(6) + "][" + match[1] + "][]";
				}
				else
				{
					if (PHP.in_array(textareas[i].name, layout_reserved_names) > -1)
					{
						alert(vbphrase["do_not_use_the_following_input_field_names_in_widgets"]);
					}
					textareas[i].name = "widgets[" + this.id.substr(6) + "][" + textareas[i].name + "]";
				}
			}

			// Rename selects
			var selects = fetch_tags(this.owner.activebox, "select");
			for (i = 0; i < selects.length; i++)
			{
				if (match = selects[i].name.match(/^(.+)(\[\])$/))
				{
					if (PHP.in_array(match[1], layout_reserved_names) > -1)
					{
						alert(vbphrase["do_not_use_the_following_input_field_names_in_widgets"]);
					}
					selects[i].name = "widgets[" + this.id.substr(6) + "][" + match[1] + "][]";
				}
				else
				{
					if (PHP.in_array(selects[i].name, layout_reserved_names) > -1)
					{
						alert(vbphrase["do_not_use_the_following_input_field_names_in_widgets"]);
					}
					selects[i].name = "widgets[" + this.id.substr(6) + "][" + selects[i].name + "]";
				}
			}

			this.owner.backupbox = this.cloneform(this.owner.activebox);
			this.owner.parambox.appendChild(this.owner.backupbox);
			YAHOO.util.Dom.setStyle(this.owner.backupbox, "display", "none");
			this.owner.overlay.show_overlaybox();
		}
	}
}

/**
* Clone html area, better than cloneNode()
*
* @param	object	Object to clone
*/
vB_CMS_Layout_Widget_DDProxy.prototype.cloneform = function(obj)
{
	var cloneobj = obj.cloneNode(true);

	var inputs = cloneobj.getElementsByTagName("input");
	for (var i = 0; i < inputs.length; i++)
	{
		if (inputs[i].type == "text" || inputs[i].type == "button")
	  {
			inputs[i].setAttribute("value", obj.getElementsByTagName("input")[i].value);
		}
		if (inputs[i].type == "checkbox" || inputs[i].type == "radio")
		{
			if (obj.getElementsByTagName("input")[i].checked == true)
			{
				inputs[i].setAttribute("checked", true);
			}
		}
	}

	var textareas = cloneobj.getElementsByTagName("textarea");
	for (i = 0; i < textareas.length; i++)
	{
		textareas[i].setAttribute("value", obj.getElementsByTagName("textarea")[i].value);
		textareas[i].defaultValue = obj.getElementsByTagName("textarea")[i].value;
	}

	var selects = cloneobj.getElementsByTagName("select");
	for (i = 0; i < selects.length; i++)
	{
		if (selects[i].multiple)
		{
			for (var j = 0; j < selects[i].options.length; j++)
			{
				if (obj.getElementsByTagName("select")[j].selected)
				{
					selects[i].options[j].selected = true;
				}
			}
		}
		else
		{
		  var index = obj.getElementsByTagName("select")[i].selectedIndex;
			if (index != -1)
  		{
				selects[i].selectedIndex = index;
   	 		selects[i].getElementsByTagName("option")[index].setAttribute("selected", true);
   	 	}
 	 	}
  }

	return cloneobj;
}

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # CVS: $RCSfile$ - $Revision: 25662 $
|| ####################################################################
\*======================================================================*/